#include <library/cpp/protobuf/json/proto2json.h>
#include <library/cpp/testing/unittest/registar.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/siphash.h>

#include <wmconsole/version3/protos/queries2.pb.h>

#include "query_utils.h"

using namespace NWebmaster;
using namespace NWebmaster::proto::queries2;

Y_UNIT_TEST_SUITE(TSearchQueriesMRTest3) {
    struct D {
        D(int p, int s, int c)
            : Position(p)
            , Shows(s)
            , Clicks(c)
        {
        }

    public:
        int Position;
        int Shows;
        int Clicks;
    };

    struct R {
        R(int r, const TVector<D> &ds)
            : Region(r)
            , Dataset(ds)
        {
        }

    public:
        int Region;
        TVector<D> Dataset;
    };

    void AddPositionInfo(QueryRegionInfo *qri, int position, int shows, int clicks) {
        QueryPositionInfo *qpi = qri->add_position_info();
        qpi->set_position(position);
        qpi->set_shows_count(shows);
        qpi->set_clicks_count(clicks);
    }

    void FillQuery(QueryMessage &msg, const TString &query, const TVector<R> &regions) {
        msg.set_corrected_query(query);

        for (const R &r : regions) {
            QueryRegionInfo *qri = msg.add_reports_by_region();
            qri->set_region_id(r.Region);

            for (const D &d : r.Dataset) {
                AddPositionInfo(qri, d.Position, d.Shows, d.Clicks);
            }
        }
    }

    const QueryMessage FilledQuery(const TString &query, const TVector<R> &regions) {
        QueryMessage msg;
        FillQuery(msg, query, regions);
        return msg;
    }

    Y_UNIT_TEST(QueriesDigest_Test01) {
        TQueryDigest hasher;

        hasher.Add(FilledQuery("test1", {
            R(1, { D(1, 2, 1), D(2, 3, 2), D(3, 5, 3) }), //shows 10, clicks 6, regions 1
            R(2, { D(1, 2, 1), D(2, 3, 2), D(3, 5, 3) }), //shows 10, clicks 6, regions 1
        })); //total shows 20, clicks 12, regions 2

        hasher.Add(FilledQuery("test2", {
            R(3, { D(2, 3, 2), D(3, 5, 3) }), //shows 8, clicks 5, regions 1
        })); //total shows 8, clicks 5, regions 1

        hasher.Add(FilledQuery("тест3", {
            R(4, { D(1, 2, 1), D(2, 3, 2), }), //shows 5, clicks 3, regions 1
        })); //total shows 5, clicks 3, regions 1

        UNIT_ASSERT_EQUAL(hasher.Signature(), "4273698170;33;20;4");
    }

    Y_UNIT_TEST(QueriesDigest_Test02) {
        QueryMessage msgSrc = FilledQuery("test1", {
            R(1, { D(1,  2, 1), D(49,  3, 2), D(50, 5, 3) }), //shows 10, clicks 6, regions 1
            R(2, { D(1,  2, 1), D(50, 3, 2), D(50, 5, 3) }), //shows 10, clicks 6, regions 1
            R(3, { D(50, 2, 1), D(50, 3, 2), D(50, 5, 3) }), //shows 10, clicks 6, regions 1
        }); //total shows 20, clicks 12, regions 2
        QueryMessage msgDst;

        UNIT_ASSERT_EQUAL(SplitQueryMessageByPosition(msgSrc, msgDst), 3);

        TQueryDigest hasher;
        hasher.Add(msgDst);

        //Cout << NProtobufJson::Proto2Json(msgDst) << Endl;
        UNIT_ASSERT_EQUAL(hasher.Signature(), "2118632654;7;4;2");
    }
}
