#include <util/draft/datetime.h>
#include <util/stream/zlib.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>
#include <util/charset/wide.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include <mapreduce/yt/common/config.h>
#include <wmconsole/version3/wmcutil/yt/yt_runner.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/args.h>

#include "partition.h"
#include "run_config.h"
#include "tasks.h"
#include "task_excluded.h"
#include "task_indexed.h"
#include "task_indexing_events.h"
#include "task_indexed_url_samples.h"
#include "task_indexing_event_samples.h"
#include "task_indexing_events.h"
#include "task_newgone.h"
#include "task_urls.h"
#include "util.h"

namespace NWebmaster {

const char *TReduceCompressPartition::F_PARTITION_ID  = "part_id";
const char *TReduceCompressPartition::F_LINE_ID       = "line_id";
const char *TReduceCompressPartition::F_ROW_ID        = "row_id";
const char *TReduceCompressPartition::F_DATA          = "data";

void TReduceCompressPartition::Do(TReader *reader, TWriter *writer) {
    TBufferOutput out;
    const size_t tableIdx = reader->GetRow()[F_PARTITION_ID].AsUint64();
    TZLibCompress compress(&out, ZLib::GZip);
    for (; reader->IsValid(); reader->Next()) {
        compress.Write(reader->GetRow()[F_DATA].AsString());
    }
    compress.Finish();
    const TBuffer &buff = out.Buffer();
    writer->AddRow(NYT::TNode()(F_DATA, TString(buff.Data(), buff.Size())), tableIdx);
}

} //namespace NWebmaster
