#pragma once

#include <util/generic/singleton.h>
#include <util/generic/string.h>

#include "tasks.h"

namespace NWebmaster {

struct TRunConfig {
    TRunConfig() = default;

    static TRunConfig &Instance() {
        return *Singleton<TRunConfig>();
    }

    static const TRunConfig &CInstance() {
        return Instance();
    }

    static void Init(size_t tablesCount, size_t textsTablesCount, size_t linesCount, ETaskType taskType,
        const TString &dateFieldValue, bool exportQueryText, time_t dateFrom, time_t dateTo,
        const TVector<TString> &tableDates, const TString &stage) {
        TRunConfig &runConfig = TRunConfig::Instance();
        runConfig.TablesCount = tablesCount;
        runConfig.TextsTablesCount = textsTablesCount;
        runConfig.LinesCount = linesCount;
        runConfig.TaskType = taskType;
        runConfig.DateFieldValue = dateFieldValue;
        runConfig.ExportQueryText = exportQueryText;
        runConfig.DateFrom = dateFrom;
        runConfig.DateTo = dateTo;
        runConfig.TableDates = tableDates;
        runConfig.Stage = stage;
    }

public:
    size_t TablesCount = 0;
    size_t TextsTablesCount = 0;
    size_t LinesCount = 0;
    ETaskType TaskType;
    TString DateFieldValue;
    bool ExportQueryText = false;
    time_t DateFrom = 0;
    time_t DateTo = 0;
    TVector<TString> TableDates;
    TString Stage;
};

} //namespace NWebmaster
