#include <util/digest/fnv.h>
#include <util/string/builder.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "partition.h"
#include "run_config.h"
#include "task_achievements.h"
#include "tasks.h"
#include "util.h"

namespace NWebmaster {

const char *FIELD_OWNER = "Owner";
const char *FIELD_TLD = "Tld";
const char *FIELD_POPULAR = "Popular";
const char *FIELD_USER_SELECTION = "UserSelection";
const char *FIELD_OFFICIAL = "Official";
const char *FIELD_OFFICIAL_MFO = "OfficialMfo";
const char *FIELD_OFFICIAL_SSD = "OfficialSsd";
const char *FIELD_OFFICIAL_AUTO = "OfficialAuto";
const char *FIELD_OFFICIAL_VISA = "OfficialVisa";
const char *FIELD_OFFICIAL_YANDEX = "OfficialYandex";
const char *FIELD_OFFICIAL_CBR = "OfficialCbr";
//const char *FIELD_SERVICE_CENTER = "ServiceCenter";
//const char *FIELD_BRANDS = "Brands";
//const char *FIELD_OFFICIAL_AIRLINE = "OfficialAvia";
//const char *FIELD_OFFICIAL_EMBASSY = "OfficialEmbassy";
//const char *FIELD_OFFICIAL_VISA_CENTER = "OfficialVisaCenter";
const char *FIELD_TASIX = "Tasix";

void TMapAchievements::Do(TReader *reader, TWriter *writer) {
    const TRunConfig &config = TRunConfig::CInstance();
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        const TString &owner = row[FIELD_OWNER].AsString();
        size_t partId = FnvHash<size_t>(owner) % config.TablesCount;
        size_t lineId = (FnvHash<size_t>(owner) / config.TablesCount) % config.LinesCount;

        data << config.DateFieldValue << "\t"
             << owner << "\t"
             << PrintNumOrDefault(row, FIELD_USER_SELECTION, 0) << "\t"
             << PrintNumOrDefault(row, FIELD_POPULAR, 0) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_AUTO) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_MFO) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_SSD) << "\t"
             << PrintBool(row, FIELD_OFFICIAL) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_VISA) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_YANDEX) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_CBR) << "\t"
             << "0" << "\t" // TODO OFFICIAL_CBR_LICENSE_OFF
             << "" /*NYTUtils::GetNodeFieldOrDefault<TString>(row, FIELD_SERVICE_CENTER, "")*/ << "\t" // service_center
             << "" /*NYTUtils::GetNodeFieldOrDefault<TString>(row, FIELD_BRANDS, "")*/ << "\t" // brands
             << "0" << "\t" // TODO temp remove after full update   OFFICIAL_SERVICE_CENTER
             << "0" << "\t" // TODO temp remove after full update   OFFICIAL_SERVICE_CENTER_BRANDS
             << "0" << "\t" // TODO UNSAFE_HOST
             << "0" /*PrintBool(row, FIELD_OFFICIAL_AIRLINE)*/  << "\t"
             << "0" /*PrintBool(row, FIELD_OFFICIAL_EMBASSY)*/  << "\t"
             << "0" /*PrintBool(row, FIELD_OFFICIAL_VISA_CENTER)*/  << "\n";

        writer->AddRow(NYT::TNode()
                           (TReduceCompressPartition::F_PARTITION_ID, partId)
                           (TReduceCompressPartition::F_LINE_ID, lineId)
                           (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                           (TReduceCompressPartition::F_DATA, data)
        );
        data.clear();
    }
}

void TMapAchievementsKuub::Do(TReader *reader, TWriter *writer) {
    const TRunConfig &config = TRunConfig::CInstance();
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        const TString &owner = row[FIELD_OWNER].AsString();
        size_t partId = FnvHash<size_t>(owner) % config.TablesCount;
        size_t lineId = (FnvHash<size_t>(owner) / config.TablesCount) % config.LinesCount;
        data << config.DateFieldValue << "\t"
             << owner << "\t"
             << row[FIELD_TLD].AsString() << "\t"
             << PrintNumOrDefault(row, FIELD_USER_SELECTION, 0) << "\t"
             << PrintNumOrDefault(row, FIELD_POPULAR, 0) << "\t"
             << PrintBool(row, FIELD_OFFICIAL) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_VISA) << "\t"
             << PrintBool(row, FIELD_OFFICIAL_YANDEX) << "\t"
             << PrintBool(row, FIELD_TASIX) << "\n";

        writer->AddRow(NYT::TNode()
                           (TReduceCompressPartition::F_PARTITION_ID, partId)
                           (TReduceCompressPartition::F_LINE_ID, lineId)
                           (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                           (TReduceCompressPartition::F_DATA, data)
        );
        data.clear();
    }
}

} //namespace NWebmaster
