#include <util/digest/fnv.h>
#include <util/string/builder.h>

#include <util/generic/hash_set.h>
#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include "partition.h"
#include "run_config.h"
#include "task_host_threats.h"
#include "util.h"

namespace NWebmaster {

void TMapHostThreats::Do(TReader *reader, TWriter *writer) {
    const THashSet<TString> &STOP_HOSTS = GetStopHostsList();

    const TRunConfig &config = TRunConfig::CInstance();
    const TString &date = config.DateFieldValue;

    for (; reader->IsValid(); reader->Next()) {
        const TString &host = reader->GetRow()["host"].AsString();
        const TString &hostId = GetHostId(host);
        if (STOP_HOSTS.contains(hostId)) {
            continue;
        }
        TStringBuilder data;
        const TString &threats = reader->GetRow()["threats"].AsString();
        size_t hostHash = FnvHash<size_t>(host);
        size_t partId = hostHash % config.TablesCount;
        size_t lineId = (hostHash / config.TablesCount) % config.LinesCount;

        data << date << "\t"
             << host << "\t"
             << encode(threats) << "\n";
        if (data.Size() > 0) {
            writer->AddRow(NYT::TNode()
                               (TReduceCompressPartition::F_PARTITION_ID, partId)
                               (TReduceCompressPartition::F_LINE_ID, lineId)
                               (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                               (TReduceCompressPartition::F_DATA, data)
            );
            data.clear();
        }
    }
}

} //namespace NWebmaster
