#include <util/digest/fnv.h>
#include <util/string/builder.h>
#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>
#include "partition.h"
#include "run_config.h"
#include "task_iks.h"
#include "util.h"

namespace NWebmaster {
    namespace {
        const char *FIELD_OWNER = "Owner";
        const char *FIELD_MAIN_MIRROR = "MainMirror";
        const char *FIELD_IKS = "IKS";
        const char *FIELD_PREV_IKS = "PreviousIKS";
        const char *FIELD_TITLE = "Title";
    }

    void PackIKS(const NYT::TNode &row, TStringBuilder &data) {
        const TRunConfig &config = TRunConfig::CInstance();
        data << config.DateFieldValue << "\t"
             << encode(row[FIELD_OWNER].AsString()) << "\t"
             << encode(row[FIELD_MAIN_MIRROR].AsString()) << "\t"
             << PrintNumOrDefault(row, FIELD_IKS, 0) << "\t"
             << PrintNumOrDefault(row, FIELD_PREV_IKS, 0) << "\t"
             << encode(row[FIELD_TITLE].AsString()) << "\n";
    }

    void TMapIKS::Do(TReader *reader, TWriter *writer) {
        const TRunConfig &config = TRunConfig::CInstance();
        TStringBuilder data;
        for (; reader->IsValid(); reader->Next()) {
            const TString &owner = reader->GetRow()[FIELD_OWNER].AsString();
            ui64 hash = FnvHash<size_t>(owner);
            size_t partId = hash % config.TablesCount;
            hash /= config.TablesCount;
            size_t lineId = hash % config.LinesCount;
            PackIKS(reader->GetRow(), data);
            if (data.Size() > 0) {
                writer->AddRow(NYT::TNode()
                                       (TReduceCompressPartition::F_PARTITION_ID, partId)
                                       (TReduceCompressPartition::F_LINE_ID, lineId)
                                       (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                                       (TReduceCompressPartition::F_DATA, data)
                );
            }
            data.clear();
        }
    }

} //namespace NWebmaster

