#include <util/digest/fnv.h>
#include <util/digest/city.h>
#include <util/generic/hash.h>
#include <util/string/builder.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include "partition.h"
#include "run_config.h"
#include "task_indexed_url_samples.h"
#include "util.h"

namespace NWebmaster {

namespace {
const char *FIELD_HOST = "Host";
const char *FIELD_PATH = "Path";
const char *FIELD_TIMESTAMP = "Timestamp";
const char *FIELD_HTTP_CODE = "HttpCode";
}

void TMapIndexedUrlSamples::Do(TReader *reader, TWriter *writer) {
    const TRunConfig &config = TRunConfig::CInstance();
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        const TString &hostId = GetHostId(row[FIELD_HOST].AsString());
        const time_t timestamp = GetJavaTimestamp(row, FIELD_TIMESTAMP);

        data
            << hostId << "\t"
            << timestamp << "\t"
            << encode(row[FIELD_PATH].AsString()) << "\t"
            << PrintNumOrDefault(row, FIELD_HTTP_CODE, 0) << "\n";

        NYT::TNode resultRow;
        resultRow["data"] = data;
        resultRow["TableId"] = FnvHash<size_t>(hostId) % config.TablesCount;
        resultRow["PartitionKey"] = ToString(CityHash64(hostId) % 16);
        resultRow["OrderKey"] = Sprintf("%s%016lX", hostId.c_str(), timestamp);
        resultRow["IsPacked"] = false;
        writer->AddRow(resultRow);
        data.clear();
    }
}

} //namespace NWebmaster
