#include <util/digest/fnv.h>
#include <util/string/builder.h>
#include <library/cpp/string_utils/quote/quote.h>

#include <util/generic/hash_set.h>
#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/protos/links.pb.h>
#include <wmconsole/version3/wmcutil/hostid.h>

#include "partition.h"
#include "run_config.h"
#include "task_link_stats.h"
#include "util.h"

namespace NWebmaster {

void TMapLinkStats::Do(TReader *reader, TWriter *writer) {
    const THashSet<TString> &STOP_HOSTS = GetStopHostsList();

    const TRunConfig &config = TRunConfig::CInstance();
    const TString &date = config.DateFieldValue;
    for (; reader->IsValid(); reader->Next()) {
        const TString &hostId = GetHostId(reader->GetRow()["key"].AsString());
        if (STOP_HOSTS.contains(hostId)) {
            continue;
        }
        TStringBuilder data;
        const TString &value = reader->GetRow()["value"].AsString();
        size_t hash = FnvHash<size_t>(hostId);
        size_t partId = hash % config.TablesCount;
        size_t lineId = (hash / config.TablesCount) % config.LinesCount;

        data << date << "\t"
             << hostId << "\t"
             << encode(value) << "\n";
        writer->AddRow(NYT::TNode()
                       (TReduceCompressPartition::F_PARTITION_ID, partId)
                       (TReduceCompressPartition::F_LINE_ID, lineId)
                       (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                       (TReduceCompressPartition::F_DATA, data)
                       );
        data.clear();
    }
}

} //namespace NWebmaster
