#include <util/digest/fnv.h>
#include <util/digest/city.h>
#include <util/string/builder.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "partition.h"
#include "run_config.h"
#include "task_memorandum.h"
#include "tasks.h"
#include "util.h"

namespace NWebmaster {

namespace {
const char *FIELD_HOST_ID = "HostId";
const char *FIELD_PATH = "Path";
const char *FIELD_C_OBJECT = "CopyrightObject";
const char *FIELD_C_OWNER = "CopyrightOwner";
}

void TMapMemorandum::Do(TReader *reader, TWriter *writer) {
    const TRunConfig &config = TRunConfig::CInstance();
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        const TString &hostId = row[FIELD_HOST_ID].AsString();
        const TString &path = row[FIELD_PATH].AsString();

        data
            << encode(hostId) << "\t"
            << encode(path) << "\t"
            << encode(row[FIELD_C_OBJECT].AsString()) << "\t"
            << encode(row[FIELD_C_OWNER].AsString()) << "\n";

        NYT::TNode resultRow;
        resultRow["data"] = data;
        resultRow["TableId"] = FnvHash<size_t>(hostId) % config.TablesCount;
        resultRow["PartitionKey"] = ToString(CityHash64(hostId) % 16);
        resultRow["OrderKey"] = Sprintf("%s%s", hostId.c_str(), path.c_str());
        resultRow["IsPacked"] = false;
        writer->AddRow(resultRow);
        data.clear();
    }
}

} //namespace NWebmaster
