#pragma once

#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/protos/queries2.pb.h>

#include "util.h"

namespace NWebmaster {

struct TMapQueriesTopUrls : public NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {

    void Do(TReader *reader, TWriter *writer) override;

    void WriteQueryValues(size_t tableId, const TString &hostId, int64_t pathId,
        const proto::queries2::QueryMessage &message, TWriter* writer);

    void WriteQueryStat(size_t tableId, const TString &date, const TString &hostId, int64_t pathId,
        const TQueryStat &queryStat, int32_t regionId, const TString &deviceType, TWriter* writer);
};

} //namespace NWebmaster
