#include <util/digest/fnv.h>
#include <util/digest/city.h>
#include <util/string/builder.h>

#include <util/generic/hash_set.h>
#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/protos/queries2.pb.h>

#include "partition.h"
#include "run_config.h"
#include "task_queries_week.h"
#include "util.h"

namespace NWebmaster {

void TMapQueriesWeek::WriteQueryData(size_t tableId, const TString &hostId, int64_t queryId,
                                    const proto::queries2::QueryWeightedAggrInfo &message, TWriter *writer) {
    const TString queryIdString = ToString(queryId);
    TQueryStat queryStat(message);

    TStringBuilder data;
    data << hostId << "\t"
         << queryIdString << "\t"
         << encode(message.query()) << "\t"
         << encode(message.url()) << "\t"
         << ToString(queryStat.ShowsTotal) << "\t"
         << ToString(queryStat.ClicksTotal) << "\t"
         << ToString(queryStat.Shows_1) << "\t"
         << ToString(queryStat.Clicks_1) << "\t"
         << ToString(queryStat.Shows_2_3) << "\t"
         << ToString(queryStat.Clicks_2_3) << "\t"
         << ToString(queryStat.AgrPosShows_2_3) << "\t"
         << ToString(queryStat.AgrPosClicks_2_3) << "\t"
         << ToString(queryStat.Shows_4_10) << "\t"
         << ToString(queryStat.Clicks_4_10) << "\t"
         << ToString(queryStat.AgrPosShows_4_10) << "\t"
         << ToString(queryStat.AgrPosClicks_4_10) << "\t"
         << ToString(queryStat.Shows_11_50) << "\t"
         << ToString(queryStat.Clicks_11_50) << "\t"
         << ToString(queryStat.AgrPosShows_11_50) << "\t"
         << ToString(queryStat.AgrPosClicks_11_50) << "\n";

    NYT::TNode row;
    row["data"] = data;
    row["TableId"] = tableId;
    row["PartitionKey"] = ToString(CityHash64(hostId) % 128);
    row["OrderKey"] =  Sprintf("%s%016lX", hostId.c_str(), (ui64) queryId + 0x800000000000000);
    row["IsPacked"] = false;
    writer->AddRow(row);
}

void TMapQueriesWeek::Do(TReader *reader, TWriter *writer) {
    const THashSet<TString> &STOP_HOSTS = GetStopHostsList();

    const TRunConfig &config = TRunConfig::CInstance();
    proto::queries2::QueryWeightedAggrInfo message;
    for (; reader->IsValid(); reader->Next()) {
        const TString &hostId = GetHostId(reader->GetRow()["key"].AsString());
        if (STOP_HOSTS.contains(hostId)) {
            continue;
        }
        message.Clear();
        Y_PROTOBUF_SUPPRESS_NODISCARD message.ParseFromString(reader->GetRow()["value"].AsString());
        int64_t queryId = JavaQueryHash(message.query());
        size_t tableId = FnvHash<size_t>(hostId) % config.TablesCount;

        WriteQueryData(tableId, hostId, queryId, message, writer);
    }
}

} //namespace NWebmaster
