#include <util/digest/fnv.h>
#include <util/string/builder.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include "partition.h"
#include "run_config.h"
#include "task_recommended_urls.h"
#include "util.h"

namespace NWebmaster {

namespace {
const char *FIELD_HOST = "Host";
const char *FIELD_PATH = "Path";
const char *FIELD_CLICKS = "Clicks";
const char *FIELD_SHOWS = "Shows";
}

void PackRecommendedUrls(const NYT::TNode &row, TStringBuilder &data) {
    const TRunConfig &config = TRunConfig::CInstance();
    data << config.DateFieldValue << "\t"
         << GetHostId(row[FIELD_HOST].AsString()) << "\t"
         << encode(row[FIELD_PATH].AsString()) << "\t"
         << PrintNumOrDefault(row, FIELD_CLICKS, 0) << "\t"
         << PrintNumOrDefault(row, FIELD_SHOWS, 0) << "\n";
}

void TMapRecommendedUrls::Do(TReader *reader, TWriter *writer) {
    const TRunConfig &config = TRunConfig::CInstance();
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        size_t partId = (FnvHash<size_t>(reader->GetRow()[FIELD_HOST].AsString())) % config.TablesCount;
        size_t lineId = (FnvHash<size_t>(reader->GetRow()[FIELD_PATH].AsString())) % config.LinesCount;
        PackRecommendedUrls(reader->GetRow(), data);
        if (data.Size() > 0) {
            writer->AddRow(NYT::TNode()
                               (TReduceCompressPartition::F_PARTITION_ID, partId)
                               (TReduceCompressPartition::F_LINE_ID, lineId)
                               (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                               (TReduceCompressPartition::F_DATA, data)
            );
        }
        data.clear();
    }
}

} //namespace NWebmaster
