#include <util/digest/fnv.h>
#include <util/string/builder.h>

#include <library/cpp/getopt/last_getopt.h>
#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>
#include <wmconsole/version3/wmcutil/hostid.h>
#include <wmconsole/version3/wmcutil/url.h>

#include "partition.h"
#include "run_config.h"
#include "task_turbo_urls.h"
#include "util.h"

namespace NWebmaster {

namespace {
const char *FIELD_URL = "url";
const char *FIELD_TURBO_URL = "turbo_url";
}

void TMapTurboUrls::Do(TReader *reader, TWriter *writer) {
    const THashSet<TString> &STOP_HOSTS = GetStopHostsList();

    const TRunConfig &config = TRunConfig::CInstance();
    const TString &date = config.DateFieldValue;
    TStringBuilder data;
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        const TString &url = row[FIELD_URL].AsString();
        TString host, path;
        if (!NUtils::SplitUrl(url, host, path)) {
            return;
        }
        TString hostId = TWebmasterHostId::FromHostname(host).Str();
        if (STOP_HOSTS.contains(hostId)) {
            continue;
        }
        TStringBuilder data;
        size_t partId = FnvHash<size_t>(hostId) % config.TablesCount;
        size_t lineId = FnvHash<size_t>(url) % config.LinesCount;

        data << date << "\t"
             << hostId << "\t"
             << encode(url) << "\t"
             << encode(row[FIELD_TURBO_URL].AsString()) << "\n";
        writer->AddRow(NYT::TNode()
                       (TReduceCompressPartition::F_PARTITION_ID, partId)
                       (TReduceCompressPartition::F_LINE_ID, lineId)
                       (TReduceCompressPartition::F_ROW_ID, reader->GetRowIndex())
                       (TReduceCompressPartition::F_DATA, data)
                       );
        data.clear();
    }
}

} //namespace NWebmaster
