#pragma once

#include <util/draft/datetime.h>
#include <util/string/printf.h>
#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/protos/queries2.pb.h>

namespace NWebmaster {

const THashSet<TString> &GetStopHostsList();

inline TString LocalDateFromTime(time_t time) {
    struct tm theTm;
    localtime_r(&time, &theTm);
    return Sprintf("%04d-%02d-%02d", theTm.tm_year + 1900, theTm.tm_mon + 1, theTm.tm_mday);
}

TString encode(const TString &in);
TString GetHostId(const TString &hostName);
time_t GetJavaTimestamp(const NYT::TNode &row, const TString &field);
int64_t GetNodeId(const NYT::TNode &raw);
time_t GetTimestamp(const NYT::TNode &row, const TString &field);
uint64_t GetUnsigned(const NYT::TNode &row, const TString &field, uint64_t defaultValue);
int64_t JavaStringHashCode(const TString &s);
int64_t JavaQueryHash(const TString &queryText);
TString PrintBool(const NYT::TNode &row, const TString &field);
TString PrintNullableString(const NYT::TNode &row, const TString &field);
TString PrintNumOrDefault(const NYT::TNode &row, const TString &field, int64_t defaultValue);
TString PrintTimestampField(const NYT::TNode &row, const TString &field);
TString PrintDeviceType(bool isMobile, bool isPad);

struct TQueryStat {
    TQueryStat() = default;
    TQueryStat(const proto::queries2::QueryRegionInfo &regionInfo) {
        Add(regionInfo);
    }
    TQueryStat(const proto::queries2::QueryWeightedAggrInfo &weightedInfo) {
        Add(weightedInfo);
    }

    void Add(const proto::queries2::QueryRegionInfo &regionInfo);
    void Add(const proto::queries2::QueryWeightedAggrInfo &weightedInfo);

public:
    int64_t SerpsTotal = 0;
    int64_t ShowsTotal = 0;
    int64_t ClicksTotal = 0;
    int64_t Shows_1 = 0;
    int64_t Clicks_1 = 0;
    int64_t Shows_2_3 = 0;
    int64_t Clicks_2_3 = 0;
    int64_t AgrPosShows_2_3 = 0;
    int64_t AgrPosClicks_2_3 = 0;
    int64_t Shows_4_10 = 0;
    int64_t Clicks_4_10 = 0;
    int64_t AgrPosShows_4_10 = 0;
    int64_t AgrPosClicks_4_10 = 0;
    int64_t Shows_11_50 = 0;
    int64_t Clicks_11_50 = 0;
    int64_t AgrPosShows_11_50 = 0;
    int64_t AgrPosClicks_11_50 = 0;
    int64_t Shows_1_50 = 0;
    int64_t Clicks_1_50 = 0;
    int64_t AgrPosShows_1_50 = 0;
    int64_t AgrPosClicks_1_50 = 0;
};
} //namespace NWebmaster
