from string import Template
import datetime
import json
from yt.wrapper.client import Yt
import yt
import wmconsole.version3.protos.exported_pb2 as exported_pb2
import html_main
import os

client = Yt(proxy='arnold.yt.yandex.net', token=os.getenv("YT_TOKEN"))


class KiwiUrlViewer:
    title = "Kiwi Url"
    path = "/kiwiurl"

    tables = [
        "//home/webmaster/prod/kiwi/url-merged",
        "//home/webmaster/prod/kiwi/removed.url-merged"
    ]

    html_nav = """
                <form class="navbar-form navbar-left" action="/kiwiurl" role="search">
                    <div class="input-group navbar-searchbox">
                        <input type="text" name="q" class="form-control" value="$url" placeholder="http://site.ru/url" style="width:400px">
                        <input type="hidden" name="t" value="$table_path">
                        <span class="input-group-btn">
                            <button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-search" style="width:40px"></span></button>
                        </span>
                    </div>
                </form>

                <ul class="nav navbar-nav navbar-right">
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">$table_name<span class="caret"></span></a>
                        <ul class="dropdown-menu scrollable-menu" role="menu">
                            $table_list
                        </ul>
                    </li>
                </ul>
    """

    html_body = """
        <div class="container">
            <div class="panel panel-default">
                <div class="panel-body">
                    <pre>$proto</pre>
                </div>
            </div>
        </div>
    """

    def __init__(self):
        pass

    def get_content(self, url, table):
        content = ""

        input = table + ("[\"%s\"]" % url)

        for line in client.read_table(input, raw=False, format=yt.wrapper.DsvFormat()):
            obj = exported_pb2.KiwiUrlRecordInfo()

            try:
                obj.ParseFromString(line["value"])
            except:
                pass

            content = "Key: %s\n\n" % line["key"]
            content += str(obj)

            content += "\nhuman(spider_timestamp): %s" % str(datetime.datetime.fromtimestamp(obj.spider_timestamp))
            content += "\nhuman(walrus_timestamp): %s" % str(datetime.datetime.fromtimestamp(obj.walrus_timestamp))
            content += "\n"

            if obj.url_info and obj.url_info.page_content_info and obj.url_info.page_content_info.meta_description_json:
                metadescr_json = obj.url_info.page_content_info.meta_description_json
                metadescr_json = json.loads(metadescr_json)
                metadescr_json = json.dumps(metadescr_json, indent=4, sort_keys=True, ensure_ascii=False)

                try:
                    metadescr_json = metadescr_json.encode("utf8")
                except:
                    pass

                content += "\nMetaDescription:\n" + metadescr_json

            break

        return self.html_body.replace("$proto", content)

    def get_beauty_table_name(self, name):
        text = name
        if "removed" in text:
            return "REMOVED_URLS"
        else:
            return "BASE_URLS"

    def process(self, path, qs, request):
        body_content = ""
        tables_content = ""

        url = qs.get("q", "")
        table = qs.get("t", self.tables[0])

        try:
            if len(url) > 0:
                body_content = self.get_content(url, table)
            pass
        except yt.wrapper.YtResponseError as e:
            body_content = "<pre>" + str(e) + "</pre>"

        for tn in self.tables:
            if tn is None:
                tables_content = tables_content + """<li class="divider"></li>"""
                continue

            tables_content = tables_content + ("""<li><a href="/kiwiurl?&q=%s&t=%s">%s</a></li>""" % (url, tn, self.get_beauty_table_name(tn)))

        nav = Template(self.html_nav).substitute(url=url, table_path=table, table_name=self.get_beauty_table_name(table), table_list=tables_content)
        answer = Template(html_main.html_core_page).substitute(title=self.title, nav=nav, viewers=request.get_viewers_content(url), body=body_content)

        request.send_response(200)
        request.send_header('content-type', 'text/html')
        request.end_headers()

        request.wfile.write(answer)
