from string import Template
import datetime
from yt.wrapper.client import Yt
import yt
import wmconsole.version3.protos.exported_pb2 as exported_pb2
import html_main
import os

client = Yt(proxy='arnold.yt.yandex.net', token=os.getenv("YT_TOKEN"))


class RobotsTxtViewer:
    title = "RobotsTxt"
    path = "/robotstxt"

    tables = [
        "//home/webmaster/prod/export/robots_txt",
    ]

    html_nav = """
                <form class="navbar-form navbar-left" action="/robotstxt" role="search">
                    <div class="input-group navbar-searchbox">
                        <input type="text" name="q" class="form-control" value="$url" placeholder="http://site.ru" style="width:400px">
                        <input type="hidden" name="t" value="$table_path">
                        <span class="input-group-btn">
                            <button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-search" style="width:40px"></span></button>
                        </span>
                    </div>
                </form>

                <ul class="nav navbar-nav navbar-right">
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">$table_name<span class="caret"></span></a>
                        <ul class="dropdown-menu scrollable-menu" role="menu">
                            $table_list
                        </ul>
                    </li>
                </ul>
    """

    html_body = """
        <div class="container">
            <div class="panel panel-default">
                <div class="panel-body">
                    <pre>$proto</pre>
                </div>
            </div>
        </div>
    """

    def __init__(self):
        pass

    def get_content(self, url, table):
        content = ""

        input = table + ("[\"%s\"]" % url)

        for line in client.read_table(input, raw=False, format=yt.wrapper.DsvFormat()):
            obj = exported_pb2.RobotsTxtInfo()

            try:
                obj.ParseFromString(line["value"])
            except:
                pass

            content = "Key: %s\n\n" % line["key"]
            content += str(obj)

            content += "\nupdated: %s" % str(datetime.datetime.fromtimestamp(int(line["subkey"])))
            content += "\n"

            if obj.content:
                robots = obj.content.replace("\\n", "\n")
                content += "\nrobots.txt:\n" + robots

            break

        return self.html_body.replace("$proto", content)

    def get_beauty_table_name(self, name):
        # text = name
        # ...
        return "BASE"

    def process(self, path, qs, request):
        body_content = ""
        tables_content = ""

        url = qs.get("q", "")
        table = qs.get("t", self.tables[0])

        try:
            if len(url) > 0:
                body_content = self.get_content(url, table)
            pass
        except yt.wrapper.YtResponseError as e:
            body_content = "<pre>" + str(e) + "</pre>"

        for tn in self.tables:
            if tn is None:
                tables_content = tables_content + """<li class="divider"></li>"""
                continue

            tables_content = tables_content + ("""<li><a href="/robotstxt?&q=%s&t=%s">%s</a></li>""" % (url, tn, self.get_beauty_table_name(tn)))

        nav = Template(self.html_nav).substitute(url=url, table_path=table, table_name=self.get_beauty_table_name(table), table_list=tables_content)
        answer = Template(html_main.html_core_page).substitute(title=self.title, nav=nav, viewers=request.get_viewers_content(url), body=body_content)

        request.send_response(200)
        request.send_header('content-type', 'text/html')
        request.end_headers()

        request.wfile.write(answer)
