from string import Template
import html_main
import urllib2


class SearchqueriesDataViewer:
    title = "Search queries"
    path = "/sq"

    html_nav = """
            <form class="navbar-form navbar-left" action="/sq" role="search">
                <div class="input-group navbar-searchbox">
                    <input type="text" name="q" class="form-control" value="$url" placeholder="http://site.ru" style="width:400px">
                    <input type="text" name="t" class="form-control" value="$query" placeholder="" style="width:400px">
                    <span class="input-group-btn">
                        <button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-search" style="width:40px"></span></button>
                    </span>
                </div>
            </form>
    """

    html_body = """
            <div class="container">
                <div class="panel panel-default">
                    <div class="panel-body">
                    <pre>$answer</pre>
                    </div>
                </div>
            </div>
    """

    def get_content(self, url, query):
        content = ""
        proxy = "http://webmaster.dev.search.yandex.net:25050/query?host=%s&query=%s" % (url, query.replace(" ", "+"))
        print proxy
        request = urllib2.Request(url=proxy,)
        response = urllib2.urlopen(request)
        content = response.read()

        return self.html_body.replace("$answer", content)

    def process(self, path, qs, request):
        body_content = ""
        url = qs.get("q", "").replace("http://", "")
        query = qs.get("t", "")

        try:
            if len(url) > 0:
                body_content = self.get_content(url, query)
        except IOError as e:
            body_content = "<pre>" + str(e) + "</pre>"

        nav = Template(self.html_nav).substitute(url=url, query=query)
        answer = Template(html_main.html_core_page).substitute(title=self.title, nav=nav, viewers=request.get_viewers_content(url), body=body_content)

        request.send_response(200)
        request.send_header('content-type', 'text/html')
        request.end_headers()

        request.wfile.write(answer)
