from string import Template
import datetime
import re
from yt.wrapper.client import Yt
import yt
import wmconsole.version3.protos.urltree_pb2 as urltree_pb2
import html_main
import os

client = Yt(proxy='arnold.yt.yandex.net', token=os.getenv("YT_TOKEN"))


class SiteTreeViewer:
    title = "Sitetree"
    path = "/sitetree"

    html_nav = """
                <form class="navbar-form navbar-left" action="/sitetree" role="search">
                    <div class="input-group navbar-searchbox">
                        <input type="text" name="q" class="form-control" value="$url" placeholder="http://site.ru" style="width:400px">
                        <input type="hidden" name="t" value="$table_path">
                        <span class="input-group-btn">
                            <button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-search" style="width:40px"></span></button>
                        </span>
                    </div>
                </form>

                <ul class="nav navbar-nav navbar-right">
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">$table_name<span class="caret"></span></a>
                        <ul class="dropdown-menu scrollable-menu" role="menu">
                            $table_list
                        </ul>
                    </li>
                </ul>
    """

    html_body = """
        <div class="container">
            <div class="panel panel-default">
                <div class="panel-body">
                    <pre>$proto</pre>
                </div>
            </div>
        </div>
    """

    tables = []

    def __init__(self):
        self.update_table_list()

    def is_sitetree_table(self, table):
        for part in ["sitetree/transmitted-", "sitetree/ready-", "sitetree/suspicious-"]:
            if part in table:
                return True
        return False

    def update_table_list(self):
        self.tables = []

        for src_dir in ["//home/webmaster/prod/sitetree", "//home/webmaster/test/sitetree"]:
            ordered_tables = {}
            tables = [x for x in client.search(src_dir, node_type="table")]
            for table in tables:
                if not self.is_sitetree_table(table):
                    continue

                match = re.search("(\\d+)", table)
                if match:
                    ordered_tables[int(match.groups()[0])] = table

            for ts in sorted(ordered_tables, reverse=True):
                self.tables.append(ordered_tables[ts])

            self.tables.append(None)
        del self.tables[-1]

    def get_content(self, url, table):
        content = ""

        input = table + ("[\"%s\":\"%s.\"]" % (url, url))

        for line in client.read_table(input, raw=False, format=yt.wrapper.DsvFormat()):
            obj = urltree_pb2.HostInfo()
            obj.ParseFromString(line["value"])
            content = str(obj)

        return self.html_body.replace("$proto", content)

    def get_beauty_table_name(self, name):
        text = name

        match = re.search("(\\d+)", name)

        if match:
            text = str(datetime.datetime.fromtimestamp(int(match.groups()[0])))
            if "/test/" in name:
                text = text + " test"
            if "ready" in name:
                text = "<b>" + text + "</b>"
            if "suspicious" in name:
                text = "<strike>" + text + "</strike>"

        return text

    def process(self, path, qs, request):
        body_content = ""
        tables_content = ""

        url = qs.get("q", "")
        table = qs.get("t", self.tables[0])

        try:
            if len(url) > 0:
                body_content = self.get_content(url, table)
            pass
        except yt.wrapper.YtResponseError as e:
            body_content = "<pre>" + str(e) + "</pre>"

        for tn in self.tables:
            if tn is None:
                tables_content = tables_content + """<li class="divider"></li>"""
                continue

            tables_content = tables_content + ("""<li><a href="/sitetree?&q=%s&t=%s">%s</a></li>""" % (url, tn, self.get_beauty_table_name(tn)))

        nav = Template(self.html_nav).substitute(url=url, table_path=table, table_name=self.get_beauty_table_name(table), table_list=tables_content)
        answer = Template(html_main.html_core_page).substitute(title=self.title, nav=nav, viewers=request.get_viewers_content(url), body=body_content)

        request.send_response(200)
        request.send_header('content-type', 'text/html')
        request.end_headers()

        request.wfile.write(answer)

        self.update_table_list()
