#pragma once

#include <util/generic/yexception.h>

#include <library/cpp/resource/resource.h>

namespace NWebmaster {
namespace NUtil {

TString ReadBuiltin(const TString &builtin) {
    const TStringBuf builtinPrefix = "builtin://";
    Y_ENSURE(builtin.size() > builtinPrefix.size(),
        "Failed to read builtin: size of requested builtin name less than builtin prefix");
    TString path = builtin.substr(builtinPrefix.size());
    TStringBuf afterSlash(path);
    TStringBuf beforeSlash = afterSlash.NextTok('/');
    return NResource::Find(TString("/builtin/") + beforeSlash + "//" + afterSlash);
}

} //namespace NUtil
} //namespace NWebmaster
