#pragma once

#include <cmath>

#include <util/generic/deque.h>

namespace NWebmaster {
namespace NUtil {

template<class T>
inline void SplitToWindowedChunks(const TDeque<T> &src, int chunks, TDeque<TDeque<T>> &dst) {
    TDeque<TDeque<T>> tmpDst;
    tmpDst.resize(chunks);

    int chunkNo = 0;
    for (const auto &obj : src) {
        tmpDst[chunkNo % chunks].push_back(obj);
        chunkNo++;
    }

    tmpDst.swap(dst);
}

template<class T>
inline void SplitToSerialChunks(const TDeque<T> &src, int chunks, TDeque<TDeque<T>> &dst) {
    TDeque<TDeque<T>> tmpDst;
    tmpDst.resize(chunks);

    int chunkNo = 0;
    const int windowSize = std::ceil(float(src.size()) / float(chunks));
    for (const auto &obj : src) {
        tmpDst[chunkNo / windowSize].push_back(obj);
        chunkNo++;
    }

    tmpDst.swap(dst);
}

} //namespace NUtil
} //namespace NWebmaster
