#include <library/cpp/streams/lz/lz.h>

#include "compress.h"

namespace NWebmaster {
namespace NUtils {

void Compress(TString &data) {
    TString compressedData;
    TStringInput input(data);
    TStringOutput output(compressedData);
    TZLibCompress compressor(&output, ZLib::ZLib);
    TransferData(&input, &compressor);
    compressor.Finish();
    data.swap(compressedData);
}

void Decompress(TString &data) {
    TString decompressedData;
    TStringInput input(data);
    TStringOutput output(decompressedData);
    TZLibDecompress decompressor(&input);
    TransferData(&decompressor, &output);
    data.swap(decompressedData);
}

void TryDecompress(TString &data) {
    if (data.size() >= 2 && *reinterpret_cast<const ui16*>(&data.data()[0]) == 0x8B1F) {
        Decompress(data);
    }
}

void CompressLz4(TString &data) {
    TString compressedData;
    TStringInput input(data);
    TStringOutput output(compressedData);
    TLz4Compress compressor(&output);
    TransferData(&input, &compressor);
    compressor.Finish();
    data.swap(compressedData);
}

void DecompressLz4(TString &data) {
    TString decompressedData;
    TStringInput input(data);
    TStringOutput output(decompressedData);
    TLz4Decompress decompressor(&input);
    TransferData(&decompressor, &output);
    data.swap(decompressedData);
}

} //namespace NUtils
} //namespace NWebmaster
