#pragma once

#include <util/generic/buffer.h>
#include <util/stream/str.h>
#include <util/stream/buffer.h>
#include <util/stream/zlib.h>

namespace NWebmaster {
namespace NUtils {

struct TBufferedGZStream {
    TBufferedGZStream()
        : BufferOutput(Buffer)
        , Stream(&BufferOutput, ZLib::GZip)
    {
    }

    inline void Write(const char *data, size_t size) {
        Stream.Write(data, size);
    }

    inline void Clear() {
        Buffer.Clear();
    }

    inline size_t Size() const {
        return Buffer.Size();
    }

    inline char* Data() {
        return Buffer.Data();
    }

    inline void Finish() {
        Stream.Finish();
    }

private:
    TBuffer Buffer;
    TBufferOutput BufferOutput;
    TZLibCompress Stream;
};

struct TChunk : public TBufferedGZStream {
    const size_t MAX_BUFFER_SIZE = 64 * 1024 * 1024;

    typedef TSimpleSharedPtr<TChunk> Ptr;

    TChunk()
        : No(0)
    {
    }

    inline bool Overflow() const {
        return Size() > MAX_BUFFER_SIZE;
    }

public:
    int No;
};

void Compress(TString &data);
void CompressLz4(TString &data);
void Decompress(TString &data);
void DecompressLz4(TString &data);
void TryDecompress(TString &data);

} //namespace NUtils
} //namespace NWebmaster
