#pragma once

#include <time.h>
#include <util/generic/string.h>

namespace NWebmaster {
namespace NUtils {

inline TString Date2StrTZ(const time_t date, const char *format = "%Y%m%d") {
    struct tm dateTm;
    memset(&dateTm, 0, sizeof(dateTm));
    localtime_r(&date, &dateTm);
    char buf[9];
    strftime(buf, sizeof(buf), format, &dateTm);
    return TString(buf);
}

inline TString Date2StrUTC(const time_t date, const char *format = "%Y%m%d") {
    struct tm dateTm;
    memset(&dateTm, 0, sizeof(dateTm));
    gmtime_r(&date, &dateTm);
    char buf[9];
    strftime(buf, sizeof(buf), format, &dateTm);
    return TString(buf);
}

inline time_t Str2DateTZ(const TString& dateStr) {
    struct tm dateTm;
    memset(&dateTm, 0, sizeof(tm));
    strptime(dateStr.data(), "%Y%m%d", &dateTm);
    return mktime(&dateTm);
}

inline time_t Str2DateUTC(const TString& dateStr) {
    return Str2DateTZ(dateStr) - timezone;
}

}
} //namespace NWebmaster
