#include <util/stream/output.h>
#include <util/string/cast.h>
#include <library/cpp/uri/http_url.h>

#include "hostid.h"

namespace NWebmaster {

TWebmasterHostId TWebmasterHostId::Parse(const TString &str, const TString &sd, const TString &pd) {
    TWebmasterHostId id;

    size_t schemeDivider = str.find(sd);

    if (schemeDivider != TString::npos) {
        id.Scheme = str.substr(0, schemeDivider);
        id.Hostname = str.substr(schemeDivider + sd.size());
    }

    if (id.Scheme.empty()) {
        id.Scheme = "http";
        id.Hostname = str;
    }

    size_t portDivider = id.Hostname.find(pd);

    if (portDivider != TString::npos) {
        id.Port = id.Hostname.substr(portDivider + pd.size());
        id.Hostname = id.Hostname.substr(0, portDivider);
    }

    if (id.Port.empty()) {
        if (id.Scheme == "https") {
            id.Port = "443";
        } else {
            id.Port = "80";
        }
    }

    int nPort = atoi(id.Port.data());
    id.Port = ToString(nPort);
    id.Valid = Validate(id.Scheme, id.Hostname, nPort);

    id.Hostname.to_lower();

    return id;
}

bool TWebmasterHostId::Validate(const TString &scheme, const TString &hostname, int port) {
    THttpURL url;

    bool valid = port > 0 && port < 65536 && !hostname.empty();

    if (!valid) {
        return false;
    }

    if (url.Parse(scheme + "://" + hostname + ":" + ToString(port), THttpURL::FeaturesRobot) == THttpURL::ParsedOK) {
        return true;
    }

    return false;
}

TWebmasterHostId TWebmasterHostId::FromHostname(const TString &host) {
    return Parse(host, "://", ":");
}

TWebmasterHostId TWebmasterHostId::FromHostId(const TString &hostId) {
    return Parse(hostId, ":", ":");
}

TString TWebmasterHostId::ToHostName() const {
    if (!Valid) {
        return "";
    }

    TString str;
    str.append(Scheme);
    str.append("://");
    str.append(Hostname);

    if (Port != "80" && Port != "443") {
        str.append(":");
        str.append(Port);
    }

    return str;
}

} //namespace NWebmaster
