#pragma once

#include <util/stream/output.h>
#include <util/string/cast.h>
#include <library/cpp/uri/http_url.h>

namespace NWebmaster {

class TWebmasterHostId {
    TWebmasterHostId()
        : Valid(false)
    {
    }

    static TWebmasterHostId Parse(const TString &str, const TString &sd, const TString &pd);
    static bool Validate(const TString &scheme, const TString &hostname, int port);

public:
    static TWebmasterHostId FromHostname(const TString &host);
    static TWebmasterHostId FromHostId(const TString &hostId);

    TString ToHostName() const;

    inline TString Str() const {
        if (!Valid) {
            return "";
        }

        TString str;
        str.append(Scheme);
        str.append(":");
        str.append(Hostname);
        str.append(":");
        str.append(Port);
        return str;
    }

    inline bool operator==(const TWebmasterHostId &that) const {
        if (!Valid || !that.Valid) {
            return false;
        }

        return Scheme == that.Scheme
            && Hostname == that.Hostname
            && Port == that.Port;
    }

    inline bool operator<(const TWebmasterHostId &that) const {
        if (Scheme != that.Scheme) {
            return Scheme < that.Scheme;
        }

        if (Hostname != that.Hostname) {
            return Hostname < that.Hostname;
        }

        return Port < that.Port;
    }

    inline operator TString() const {
        return Str();
    }

public:
    bool Valid;
    TString Scheme;
    TString Hostname;
    TString Port;
};

} //namespace NWebmaster
