#include <util/string/vector.h>

#include "http_client.h"

namespace NWebmaster {

template <>
TString HttpGet<TString>(const TMultiHttpHandler<TString>& handler, size_t timeout) {
    TString result;

    for (TString url : handler.Handlers) {
        if (!handler.Params.empty()) {
            url += "?";
            for (const auto &obj : handler.Params) {
                url += "&" + obj.first + "=" + obj.second;
            }
        }

        result.append(HttpGet(url, timeout));
        result.append(";");
    }

    return result;
}

template <>
TString HttpPost<TString>(const TMultiHttpHandler<TString>& handler, const TString& data, const TString &contentType, size_t timeout) {
    TString result;

    for (TString url : handler.Handlers) {
        if (!handler.Params.empty()) {
            url += "?";
            for (const auto &obj : handler.Params) {
                url += "&" + obj.first + "=" + obj.second;
            }
        }

        result.append(HttpPost(url, data, contentType, timeout));
        result.append(";");
    }

    return result;
}

void Quote(TString& url, const char* safe) {
    TTempBuf tempBuf(CgiEscapeBufLen(url.size()));
    char* to = tempBuf.Data();

    url.assign(to, ::Quote(to, url.c_str(), safe));
}

} //namespace NWebmaster
