#pragma once

#ifndef WMCUTIL_LOG_H
#define WMCUTIL_LOG_H

#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/logger/all.h>

#include <util/datetime/base.h>
#include <util/stream/printf.h>
#include <util/stream/str.h>

namespace NWebmaster {

#ifdef _MSC_VER
#define PRETTY_FUNCTION __FUNCSIG__
#else
#define PRETTY_FUNCTION __PRETTY_FUNCTION__
#endif

#define LOG_CRIT(msg, ...) TLogger::Write(PRETTY_FUNCTION, TLOG_CRIT, (msg), ##__VA_ARGS__)
#define LOG_ERROR(msg, ...) TLogger::Write(PRETTY_FUNCTION, TLOG_ERR, (msg), ##__VA_ARGS__)
#define LOG_WARN(msg, ...) TLogger::Write(PRETTY_FUNCTION, TLOG_WARNING, (msg), ##__VA_ARGS__)
#define LOG_INFO(msg, ...) TLogger::Write(PRETTY_FUNCTION, TLOG_INFO, (msg), ##__VA_ARGS__)
#define LOG_DEBUG(msg, ...) TLogger::Write(PRETTY_FUNCTION, TLOG_DEBUG, (msg), ##__VA_ARGS__)
#define LOG(msg, ...) LOG_INFO(msg, ##__VA_ARGS__)

class TLogger {
private:
    static void OnLogRotate(int = 0);
    TLogger() = default;

public:
    static TLog *Instance(ELogPriority level = TLOG_INFO);
    static void Y_PRINTF_FORMAT(3,4) Write(const char *functionName, ELogPriority prio, const char *msg, ...);
    static void Rotate();

    static void LogInfo(const TString &msg) {
        LOG_INFO("%s", msg.data());
    }

public:
    static ELogPriority StringToLogLevel(const TString &level);
    static TString LogLevelToString(ELogPriority prio);

private:
    static ELogPriority Level;
};

} //namespace NWebmaster

#endif //WMCUTIL_LOG_H
