#include "monitor.h"

namespace NWebmaster {

template<class T>
void MonitorPushLabel(const TString &service, const TString &label, T value) {
    TSolomonPushBackend pushBackend("webmaster", "webmaster_performance_production");
    TMonitoringAgent<TSolomonPushBackend> agent(pushBackend);

    agent
        .Next(label, value)
        .GlobalService(service)
        .Commit();
}

template<class T>
void MonitorPushCountersLabel(const TString &label, T value) {
    MonitorPushLabel("webmaster_counters", label, value);
}

template<class T>
void MonitorPushQualityLabel(const TString &label, T value) {
    MonitorPushLabel("webmaster_quality", label, value);
}

template<class T>
void MonitorPushStateLabel(const TString &label, T value) {
    MonitorPushLabel("webmaster_state", label, value);
}

void MonitorPushMirrorsChangesShare(const TString &counter, float value) {
    MonitorPushQualityLabel( "MIRRORS_" + counter, value);
}

void MonitorPushSitemapHostrelatedChangesShare(const TString &counter, double value) {
    MonitorPushQualityLabel( "SitemapsHostrelated_" + counter, value);
}

void MonitorPushSitemapSitemapdataChangesShare(const TString &counter, double value) {
    MonitorPushQualityLabel( "SitemapsSitemapdata_" + counter, value);
}

} //namespace NWebmaster
