#pragma once

#include <mapreduce/lib/all.h>

namespace NWebmaster {

class TReduceCalcSum : public NMR::IReduce {
    OBJECT_METHODS(TReduceCalcSum)

public:
    void Do(NMR::TValue key, NMR::TTableIterator &input, NMR::TUpdate &output) {
        size_t total = 0;

        for (; input.IsValid(); ++input) {
            size_t val = FromString(input.GetValue().AsString());
            total += val;
        }

        output.Add(key, ToString(total));
    }
};

} //namespace NWebmaster

using namespace NWebmaster;
REGISTER_SAVELOAD_CLASS(0xBCDE0204, TReduceCalcSum)
