#pragma once

#include <mapreduce/lib/all.h>
#include <quality/ytlib/core/proxy.h>
#include <util/generic/list.h>
#include <util/generic/set.h>

#include <wmconsole/version3/wmcutil/path.h>

namespace NWebmaster {
namespace NStageUtils {

enum EHostScheme {
    E_HOST_SCHEME_FULL,
    E_HOST_SCHEME_ROBOT,
    E_HOST_SCHEME_NONE,
};

struct TRecord {
    TRecord(const TString &key, const TString &subkey, const TString &value)
        : Key(key)
        , SubKey(subkey)
        , Value(value)
    {
    }

public:
    TString Key;
    TString SubKey;
    TString Value;
};

template<typename... Args>
inline TString JoinPathMR(const TString &lhs, const TString &rhs, const Args&... args) {
    return NUtils::JoinPath('/', lhs, rhs, args...);
}

void AppendRecord(NMR::TServer &server, const TString &table, const TString &key, const TString &subKey = "", const TString &value = "");
void CreateDummyTable(NMR::TServer &server, const TString &dummyTable, bool overwrite = true);
void GetPathAlternative(NMR::TServer &server, const TString &sourcePrefix, TSet<TString> &alts, const char *pathDel = "/");
bool GetLatestTable(NMR::TServer &server, const TString &table_prefix, TString &tableName);
bool GetTableInfo(NMR::TServer &server, const TString &tableName, NMR::TTableInfo &tableInfo);
size_t AppendTableList(NMR::TServer &server, const TString &tablePrefix, TVector<TString> &appendTo, size_t maxCount = 500);
size_t GetTableList(NMR::TServer &server, const TString &tablePrefix, TVector<NMR::TTableInfo> &tableList, size_t maxCount = 500);
size_t GetTableList(NMR::TServer &server, const TString &table_prefix, TVector<TString> &table_list, size_t maxCount = 500);
size_t GetTableListByTime(NMR::TServer &server, const TString &table_prefix, TVector<TString> &table_list, const TDuration &duration);
TString GetTableName(const TString &path);
TString GetTempTable(const TString &prefix, const TString &name);
size_t DropTables(NMR::TServer &server, const TVector<TString> &table_list);
bool IsArchivedTableYT(NYT::TProxy &proxy, const TString& table);
bool IsEmpty(NMR::TServer &server, const TString &tableName);
void LoadRecords(NMR::TServer &server, const TString &tableName, TVector<TRecord> &records, size_t limit = Max<size_t>());
bool LoadWebmastersHosts(NMR::TServer &server, const TString &tablePrefix, THashSet<TString> &hosts, TString &tableName, EHostScheme scheme = E_HOST_SCHEME_FULL);
bool LoadWebmastersHosts(NMR::TServer &server, const TString &tablePrefix, THashSet<TString> &hosts, EHostScheme scheme = E_HOST_SCHEME_FULL);
void LogTables(const TString &message, const TVector<TString> &table_list);
void MoveTable(NMR::TServer &server, const TString &src, const TString &dest);

void ArchiveTableYT(NYT::TProxy& proxy, const TString& table, const TString& eCodec = "lrc_12_2_2", const TString& cCodec = "brotli8");
TString GetAttrYT(NYT::TProxy& proxy, const TString& table, const TString& attr);
void SetArchiveAttrYT(NYT::TProxy& proxy, const TString& table, const TString& eCodec = "lrc_12_2_2", const TString& cCodec = "brotli8");
time_t GetModifyTimeYT(NYT::TProxy& proxy, const TString& path);
size_t GetRowCountYT(NYT::TProxy& proxy, const TString& path);
TString GetSymbolicLinkYT(NYT::TProxy &proxy, const TString &table);
void SetAttrYT(NYT::TProxy& proxy, const TString& table, const TString& attr, const TString& value);
void SetSymbolicLinkYT(NYT::TProxy &proxy, TString from, TString to);
TString MrPath(const TString& table);
TString YtPath(const TString& table);

} //namespace NStageUtils
} //namespace NWebmaster
