#include "murmur3.h"

namespace NWebmaster {

#define Murmur3_ROT32(x, y) ((x << y) | (x >> (32 - y))) // avoid effort
ui32 MurmurHash3_32(const char *key, ui32 len, ui32 seed) {
    static const ui32 c1 = 0xcc9e2d51;
    static const ui32 c2 = 0x1b873593;
    static const ui32 r1 = 15;
    static const ui32 r2 = 13;
    static const ui32 m = 5;
    static const ui32 n = 0xe6546b64;

    ui32 hash = seed;

    const int nblocks = len / 4;
    const ui32 *blocks = (const ui32 *) key;
    int i;
    ui32 k;
    for (i = 0; i < nblocks; i++) {
        k = blocks[i];
        k *= c1;
        k = Murmur3_ROT32(k, r1);
        k *= c2;

        hash ^= k;
        hash = Murmur3_ROT32(hash, r2) * m + n;
    }

    const uint8_t *tail = (const uint8_t *) (key + nblocks * 4);
    ui32 k1 = 0;

    switch (len & 3) {
    case 3:
        k1 ^= tail[2] << 16;
    case 2:
        k1 ^= tail[1] << 8;
    case 1:
        k1 ^= tail[0];

        k1 *= c1;
        k1 = Murmur3_ROT32(k1, r1);
        k1 *= c2;
        hash ^= k1;
    }

    hash ^= len;
    hash ^= (hash >> 16);
    hash *= 0x85ebca6b;
    hash ^= (hash >> 13);
    hash *= 0xc2b2ae35;
    hash ^= (hash >> 16);

    return hash;
}
#undef Murmur3_ROT32

ui32 MurmurHash3_32(const TString &str, ui32 seed) {
    return MurmurHash3_32(str.data(), str.size(), seed);
}

} //namespace NWebmaster
