#include <library/cpp/string_utils/quote/quote.h>
#include <util/string/printf.h>

#include <wmconsole/version3/wmcutil/http_client.h>
#include <wmconsole/version3/wmcutil/log.h>

#include "notify_sms.h"

namespace NWebmaster {

void NotifySms(const TString &resps, TString msg) {
    NWebmaster::Quote(msg);
    const TString url = Sprintf("http://golem.yandex-team.ru/api/sms/send.sbml?resps=%s&msg=%s", resps.data(), msg.data());

    try {
        const TString answer = HttpGet(url, 1000);
        LOG_INFO("SMS \"%s\" has been sent to responsible (%s): %s", msg.data(), resps.data(), answer.data());
    } catch (yexception& e) {
        LOG_INFO("Unable to send SMS \"%s\" to responsible (%s): %s", msg.data(), resps.data(), e.what());
    }
}

} //namespace NWebmaster
