#pragma once

#include <util/string/strip.h>

#include "string.h"

namespace NWebmaster {
namespace NUtils {

template <class TChar>
struct TIsAsciiSpacePathAdapter {
    template <class It>
    bool operator()(const It& it) const noexcept {
        return IsAsciiSpace(*it) || *it == '/' || *it == '\\';
    }
};

template <class TChar>
TIsAsciiSpacePathAdapter<TChar> IsAsciiSpacePathAdapter() {
    return {};
}

inline TString JoinPath(char, const TString& s) {
    return StripString(s, IsAsciiSpacePathAdapter<char>());
}

template<typename... Args>
inline TString JoinPath(char del, const TString &lhs, const TString &rhs, const Args&... args) {
    return StripString(lhs, IsAsciiSpacePathAdapter<char>()) + del + JoinPath(del, rhs, args...);
}

} //namespace NUtils
} //namespace NWebmaster
