#pragma once

#include <util/generic/string.h>

namespace NWebmaster {

struct TPeriodicLog {
    enum EEventType {
        START,
        FINISH,
        ERROR
    };

    TPeriodicLog(const TString &taskType = "");
    virtual ~TPeriodicLog();
    TString RequestStr();

    TPeriodicLog& NewRunId();
    TPeriodicLog& Handler(const TString &handler);
    TPeriodicLog& TaskType(const TString &taskType);
    TPeriodicLog& Start(const TString &statusMsg = "");
    TPeriodicLog& Finish(const TString &statusMsg = "");
    TPeriodicLog& Error(const TString &errorMsg = "");

    static void SetDefaultHandler(const TString &handler);

private:
    const TString EventTypeStr() const;
    const TString &Handler() const;

public:
    static TString DefaultHandler;
    static TString RunId;
    TString CurrentHandler;
    TString CurrentTaskType;
    TString StatusMsg;
    TString ErrorMsg;
    EEventType EventType;
};

} //namespace NWebmaster
