#pragma once

#include <contrib/libs/pcre/pcre.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NWebmaster {

struct TRegularExpression {
    TRegularExpression(const TString &regex);
    ~TRegularExpression();

    size_t GetMatches(const TString &str, TVector<TString> &hits) const;

private:
    pcre *re;
};

void EscapePireRegexChar(wchar16 ch, TUtf16String &result);

TUtf16String EscapePireRegex(const TUtf16String &s);

TString EscapePireRegex(const TString &s);

} //namespace NWebmaster
