#pragma once

#include <util/ysaveload.h>
#include <util/stream/str.h>

namespace NWebmaster {
namespace NUtils {

template<class T>
void Serialize(const T &src, TString &dst) {
    TStringOutput so(dst);
    ::Save(&so, src);
}

template<class T>
void Deserialize(const TString &src, T &dst) {
    TStringInput si(src);
    ::Load(&si, dst);
}

} //namespace NUtils
} //namespace NWebmaster
