#pragma once

#include <util/thread/pool.h>

namespace NWebmaster {
namespace NUtils {

template <class TFunction>
inline void RunAsync(TThreadPool &mtpQueue, TFunction func) {
    mtpQueue.SafeAddFunc(func);
}

template<class TFunction, class... Args>
inline void RunAsync(TThreadPool &mtpQueue, TFunction func, Args... args) {
    mtpQueue.SafeAddFunc(func);
    RunAsync(mtpQueue, args...);
}

template<class... Args>
inline void RunAsync(Args... args) {
    TThreadPool mtpQueue(TThreadPool::TParams().SetBlocking(true).SetCatching(true));
    mtpQueue.Start(sizeof...(args));
    RunAsync(mtpQueue, args...);
    mtpQueue.Stop();
}

} //namespace NUtils
} //namespace NWebmaster
