#include <library/cpp/tld/tld.h>

#include "tld.h"

namespace NWebmaster {

bool GetTld(const TString &domain, TString &tld) {
    size_t pos = domain.rfind('.');

    if (pos == TString::npos) {
        return false;
    }

    TString tmp = domain.substr(pos + 1);
    tmp.to_lower();

    if (NTld::IsTld(tmp)) {
        tmp.swap(tld);
        return true;
    }

    return false;
}

} //namespace NWebmaster
