#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/set.h>
#include <util/stream/output.h>
#include <util/string/cast.h>
#include <library/cpp/uri/http_url.h>

#include <wmconsole/version3/wmcutil/hostid.h>

using namespace NWebmaster;

TString DebugStr(const TWebmasterHostId &hostId) {
    TString str;

    if (!hostId.Valid) {
        str.append("i");
    }

    str.append("[");
    str.append(hostId.Scheme);
    str.append("][");
    str.append(hostId.Hostname);
    str.append("][");
    str.append(hostId.Port);
    str.append("]");
    return str;
}

Y_UNIT_TEST_SUITE(TWmcUtilTest1) {
    Y_UNIT_TEST(WebmasterHostIdTest) {
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("http://")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://")), "i[https][][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://:")), "i[https][][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://:444")), "i[https][][444]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname(":")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("::")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname(":80")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("://:")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname(":/")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("://://")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://site.ru::")), "i[https][site.ru][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https:// :443")), "i[https][ ][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("site.ru")), "[http][site.ru][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("http://site.ru")), "[http][site.ru][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("http://site.ru:81")), "[http][site.ru][81]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://site.ru")), "[https][site.ru][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://site.ru:444")), "[https][site.ru][444]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://site.ru:")), "[https][site.ru][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostname("https://site.ru:80//::")), "[https][site.ru][80]");

        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("http:")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:")), "i[https][][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https::")), "i[https][][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https::444")), "i[https][][444]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId(":")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("::")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId(":::")), "i[http][][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId(":80")), "i[http][][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:site.ru::")), "i[https][site.ru][0]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https: :443")), "i[https][ ][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("site.ru")), "[http][site.ru][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("http:site.ru")), "[http][site.ru][80]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("http:site.ru:81")), "[http][site.ru][81]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:site.ru")), "[https][site.ru][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:site.ru:444")), "[https][site.ru][444]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:site.ru:")), "[https][site.ru][443]");
        UNIT_ASSERT_EQUAL(DebugStr(TWebmasterHostId::FromHostId("https:site.ru:80::")), "[https][site.ru][80]");

        UNIT_ASSERT_EQUAL(TWebmasterHostId::FromHostId("http:site.ru:80::"), TWebmasterHostId::FromHostname("http://site.ru"));
        UNIT_ASSERT_UNEQUAL(TWebmasterHostId::FromHostId("https::"), TWebmasterHostId::FromHostname("https://:"));

        TSet<TWebmasterHostId> s;
        s.insert(TWebmasterHostId::FromHostId("http:site.ru:80"));
    }
}
