#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/version3/wmcutil/monitor_client.h>

Y_UNIT_TEST_SUITE(TWmcUtilTest2) {
    Y_UNIT_TEST(MonitorClientTest) {
        TMonitoringAgent<> agent1, agent2;

        agent1
            .Next("sensor1", 1).Derived()
            .Next("sensor2", 2).Label("111", "222")
            .Next("sensor3", 3).Label("111", "222").Label("333", "444")
            .Next("sensor4", 4).TTL(100).TTL(100)
            .Next("sensor5", 5).Service("stub").Service("test");

        UNIT_ASSERT_EQUAL(
            agent1.Debug(),
            "http://localhost:3443/update?sensor=sensor1&value=1&mode=deriv\n"
            "http://localhost:3443/update?sensor=sensor2&value=2&label.111=222\n"
            "http://localhost:3443/update?sensor=sensor3&value=3&label.111=222&label.333=444\n"
            "http://localhost:3443/update?sensor=sensor4&value=4&expire=100\n"
            "http://localhost:3443/update?sensor=sensor5&value=5&service=test\n"
        );

        agent2
            .Next("sensor6", 6).GlobalTTL(200)
            .Next("sensor7", 7).GlobalService("test")
            .Next("sensor8", 8).GlobalDerived();

        UNIT_ASSERT_EQUAL(
            agent2.Debug(),
            "http://localhost:3443/update?sensor=sensor6&value=6&service=test&mode=deriv&expire=200\n"
            "http://localhost:3443/update?sensor=sensor7&value=7&service=test&mode=deriv&expire=200\n"
            "http://localhost:3443/update?sensor=sensor8&value=8&service=test&mode=deriv&expire=200\n"
        );

        TSolomonPushBackend pushBackend("webmaster", "webmaster-dev");
        TMonitoringAgent<TSolomonPushBackend> agent3(pushBackend);

        agent3
            .GlobalService("webmaster")
            .Next("KiwiUpdater_TotalFailed", 0).Timestamp(TInstant::Seconds(1432741590))
            .Next("KiwiUpdater_TotalUpdated", 100).Derived().Timestamp(TInstant::Seconds(1432741590));

        const TString fqdn = GetLocalFQDN();

        TString json =
            "{\"commonLabels\":{\"host\":\"" + fqdn + "\",\"project\":\"webmaster\",\"cluster\":\"webmaster-dev\""
            ",\"service\":\"webmaster\"},\"sensors\":[{\"labels\":{\"sensor\":\"KiwiUpdater_TotalFailed\"},\"ts\":1432741590,\"value"
            "\":0},{\"labels\":{\"sensor\":\"KiwiUpdater_TotalUpdated\"},\"ts\":1432741590,\"value\":100,\"mode\":\"deriv\"}]}";

        UNIT_ASSERT_EQUAL(agent3.Debug(), json);

        agent3.Commit();
    }
}
