#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/version3/wmcutil/owners.h>

Y_UNIT_TEST_SUITE(TOwnersTest) {
    Y_UNIT_TEST(TMetrikaOwnersTest) {
        using namespace NWebmaster::NUtils;

        TString host;

        host = "https://m.yandex.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.ru");

        host = "https://yandex.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.ru");

        host = "https://www.yandex.com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.com.ru");

        host = "https://yandex.com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.com.ru");

        host = "m.yandex.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.ru");

        host = "yandex.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.ru");

        host = "www.yandex.com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.com.ru");

        host = "yandex.com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.com.ru");

        host = "";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "");

        host = "https://com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "com.ru");

        host = "com.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "com.ru");

        host = "ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "ru");

        host = ".";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), ".");

        host = "yandex.ru.";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "ru.");

        host = ".yandex.ru";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "yandex.ru");

        host = ".yandex.com.ru.";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), "ru.");

        host = "..";
        UNIT_ASSERT_EQUAL(GetMetrikaOwner(host), ".");
    }
}
