#include <library/cpp/charset/doccodes.h>
#include <library/cpp/testing/unittest/registar.h>

#include <library/cpp/tld/tld.h>

#include <wmconsole/version3/wmcutil/tld.h>

Y_UNIT_TEST_SUITE(TTldTest) {
    Y_UNIT_TEST(TestTLDs) {
        using namespace NWebmaster;

        TString tld;
        UNIT_ASSERT(GetTld("www.yandex.ru", tld));
        UNIT_ASSERT_EQUAL(tld, "ru");
        UNIT_ASSERT(GetTld("yandex.COM", tld));
        UNIT_ASSERT_EQUAL(tld, "com");
        UNIT_ASSERT(!GetTld("lentaru", tld));
        UNIT_ASSERT_EQUAL(tld, "com");
        UNIT_ASSERT(!GetTld("", tld));
        UNIT_ASSERT(!GetTld("1", tld));
        UNIT_ASSERT(!GetTld("1.1.1.1", tld));
    }
}
