#include <util/charset/wide.h>

#include <library/cpp/testing/unittest/registar.h>

#include <wmconsole/version3/wmcutil/url.h>

#include <contrib/libs/libidn/lib/idna.h>

Y_UNIT_TEST_SUITE(TUrlTest) {
    Y_UNIT_TEST(TTestIdna) {
        using namespace NWebmaster::NUtils;

        TString asciiHost;
        UNIT_ASSERT(IDNHostToAscii("site.ru", asciiHost));
        UNIT_ASSERT_EQUAL(asciiHost, "site.ru");
        UNIT_ASSERT(IDNHostToAscii("https://site.ru", asciiHost));
        UNIT_ASSERT_EQUAL(asciiHost, "https://site.ru");
        UNIT_ASSERT(IDNHostToAscii("сайт.рф", asciiHost));
        UNIT_ASSERT_EQUAL(asciiHost, "xn--80aswg.xn--p1ai");
        UNIT_ASSERT(IDNHostToAscii("https://сайт.рф", asciiHost));
        UNIT_ASSERT_EQUAL(asciiHost, "https://xn--80aswg.xn--p1ai");
        UNIT_ASSERT(IDNHostToAscii("site1.ru", asciiHost));
        UNIT_ASSERT_UNEQUAL(asciiHost, "site2.ru");

        TString utf8Host;
        UNIT_ASSERT(IDNToUtf8("xn--80aswg.xn--p1ai", utf8Host));
        UNIT_ASSERT_EQUAL(utf8Host, "http://сайт.рф");
        UNIT_ASSERT(IDNToUtf8("http://xn--80aswg.xn--p1ai", utf8Host));
        UNIT_ASSERT_EQUAL(utf8Host, "http://сайт.рф");
        UNIT_ASSERT(IDNToUtf8("https://xn--80aswg.xn--p1ai", utf8Host));
        UNIT_ASSERT_EQUAL(utf8Host, "https://сайт.рф");
        UNIT_ASSERT(IDNToUtf8("www.site.ru", utf8Host));
        UNIT_ASSERT_EQUAL(utf8Host, "http://www.site.ru");
        UNIT_ASSERT(IDNToUtf8("https://www.site.ru", utf8Host));
        UNIT_ASSERT_EQUAL(utf8Host, "https://www.site.ru");
    }

    Y_UNIT_TEST(TTestScheme) {
        using namespace NWebmaster::NUtils;

        TString host = "https://www.site.ru";
        UNIT_ASSERT_EQUAL(RemoveScheme(host), "www.site.ru");
        UNIT_ASSERT_EQUAL(FixDomainPrefix(RemoveScheme(host)), "site.ru");
        host = "www.site.ru";
        UNIT_ASSERT_EQUAL(RemoveScheme(host), "www.site.ru");
        UNIT_ASSERT_EQUAL(FixDomainPrefix(RemoveScheme(host)), "site.ru");

        host = "";
        UNIT_ASSERT(GetHostWithoutScheme("site1.ru/", host));
        UNIT_ASSERT_EQUAL(host, "site1.ru");
        UNIT_ASSERT(GetHostWithoutScheme("https://site2.ru/", host));
        UNIT_ASSERT_EQUAL(host, "site2.ru");
        UNIT_ASSERT(GetHostWithoutScheme("http://site3.ru/", host));
        UNIT_ASSERT_EQUAL(host, "site3.ru");
        UNIT_ASSERT(!GetHostWithoutScheme("/", host));

        host = "";
        UNIT_ASSERT(GetSchemedHost("site1.ru/", host));
        UNIT_ASSERT_EQUAL(host, "http://site1.ru");
        UNIT_ASSERT(GetSchemedHost("http://site2.ru/", host));
        UNIT_ASSERT_EQUAL(host, "http://site2.ru");
        UNIT_ASSERT(GetSchemedHost("https://site3.ru", host));
        UNIT_ASSERT_EQUAL(host, "https://site3.ru");
        UNIT_ASSERT(GetSchemedHost("https://site4.ru/", host));
        UNIT_ASSERT_EQUAL(host, "https://site4.ru");
        UNIT_ASSERT(!GetSchemedHost("/", host));
    }

    Y_UNIT_TEST(TTestCgiFilter) {
        using namespace NWebmaster::NUtils;
        const THashSet<TString> params = {"b"};
        const TString url = "https://www.site.ru/?c=111&b=222&a=333&d=&b=444";
        UNIT_ASSERT_EQUAL(FilterCgiParams(params, url, true), "https://www.site.ru/?b=222&b=444");
        UNIT_ASSERT_EQUAL(FilterCgiParams(params, url, false), "https://www.site.ru/?c=111&a=333&d=");
    }
}
