#include <library/cpp/digest/md5/md5.h>

#include <util/generic/guid.h>
#include <util/random/easy.h>
#include <util/stream/format.h>
#include <util/stream/mem.h>
#include <util/string/ascii.h>
#include <util/string/builder.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/unaligned_mem.h>

#include "uuid.h"

namespace NWebmaster {

TString RandomUUID() { //"9ffeb6a6-4530-11e6-b6a6-82cfc10c4c6e"
    TGUID g;
    CreateGuid(&g);

    char buf[40];
    TMemoryOutput mo(buf, sizeof(buf));

    mo
        << Hex(g.dw[0], HF_FULL) << '-'
        << Hex((ui16)(g.dw[1] >> 16), HF_FULL) << '-'
        << Hex((ui16)(g.dw[1] & 0xFFFF), HF_FULL) << '-'
        << Hex((ui16)(g.dw[2] >> 16), HF_FULL) << '-'
        << Hex((ui16)(g.dw[2] & 0xFFFF), HF_FULL)
        << Hex(g.dw[3], HF_FULL);

    char* e = mo.Buf();

    for (char* b = buf; b != e; ++b) {
        *b = AsciiToLower(*b);
    }

    return TString(buf, e);
}

TString NameUUIDFromBytes(const TStringBuf& data) {
    TString result = MD5::CalcRaw(data);
    ui8* b = reinterpret_cast<ui8*>(result.begin());
    // copy-paste from java.util.UUID#nameUUIDFromBytes
    b[6]  &= 0x0f;  /* clear version        */
    b[6]  |= 0x30;  /* set to version 3     */
    b[8]  &= 0x3f;  /* clear variant        */
    b[8]  |= 0x80;  /* set to IETF variant  */

    TStringBuilder s;
    s
        << Hex(b[0], HF_FULL) << Hex(b[1], HF_FULL) << Hex(b[2], HF_FULL) << Hex(b[3], HF_FULL) << '-'
        << Hex(b[4], HF_FULL) << Hex(b[5], HF_FULL) << '-' << Hex(b[6], HF_FULL) << Hex(b[7], HF_FULL) << '-'
        << Hex(b[8], HF_FULL) << Hex(b[9], HF_FULL) << '-' << Hex(b[10], HF_FULL) << Hex(b[11], HF_FULL)
        << Hex(b[12], HF_FULL) << Hex(b[13], HF_FULL) << Hex(b[14], HF_FULL) << Hex(b[15], HF_FULL) << '\0';
    for (auto&& c : s) {
        c = AsciiToLower(c);
    }
    return std::move(s);
}

} //namespace NWebmaster
