#include "backlog.h"

namespace NWebmaster {
namespace NYTUtils {

TBacklog::TBacklog(NYT::IClientBasePtr client, const TString &table, const TString &key)
    : Client(client)
    , Table(table)
    , Key(key)
{
    Load();
}

void TBacklog::Add(time_t timestamp) {
    time_t now = Now().Seconds();
    auto writer = Client->CreateTableWriter<NYT::TNode>(NYT::TRichYPath(Table).Append(true));
    writer->AddRow(NYT::TNode()
        (F_KEY, Key)
        (F_TIMESTAMP, timestamp)
        (F_PROCESSED, now)
    );
    writer->Finish();
    ProcessedTimestamps[timestamp] = now;
}

bool TBacklog::Has(time_t timestamp) const {
    return ProcessedTimestamps.contains(timestamp);
}

void TBacklog::Load() {
    if (!Client->Exists(Table)) {
        Client->Create(Table,
            NYT::NT_TABLE,
            NYT::TCreateOptions()
                .Recursive(true)
        );
        return;
    }

    auto reader = Client->CreateTableReader<NYT::TNode>(Table);
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        if (row[F_KEY].AsString() == Key) {
            ProcessedTimestamps[row[F_TIMESTAMP].AsInt64()] = row[F_PROCESSED].AsInt64();
        }
    }
}

} //namespace NYTUtils
} //namespace NWebmaster
