#pragma once

#include <mapreduce/yt/interface/client.h>

namespace NWebmaster {
namespace NYTUtils {

struct TBacklog {
    const char *F_KEY = "Key";
    const char *F_PROCESSED = "Processed";
    const char *F_TIMESTAMP = "Timestamp";

    TBacklog(NYT::IClientBasePtr client, const TString &table, const TString &key);
    void Add(time_t timestamp);
    bool Has(time_t timestamp) const;

private:
    void Load();

public:
    NYT::IClientBasePtr Client;
    const TString Table;
    const TString Key;
    THashMap<time_t, time_t> ProcessedTimestamps; //what, when
};

} //namespace NYTUtils
} //namespace NWebmaster
