#include "misc.h"
#include "yt_utils.h"

namespace NWebmaster {
namespace NYTUtils {

bool LoadWebmastersHosts(NYT::IClientBasePtr client, const TString &tableName, THashSet<TString> &hosts, size_t thresholdCount, EHostScheme scheme) {
    const char *F_YAMR_KEY = "key";
    LOG_INFO("loading webmaster-hosts table %s, threshold %lu", tableName.data(), thresholdCount);
    NYT::ITransactionPtr tx = client->StartTransaction();
    hosts.clear();

    TTableInfo tableInfo;
    if (!GetTableInfo(tx, tableName, tableInfo)) {
        LOG_ERROR("there is no webmaster-hosts table with name %s", tableName.data());
        return false;
    }

    if (tableInfo.RecordCount < thresholdCount) {
        LOG_ERROR("webmaster hosts table %s has low record count: %lu", tableName.data(), tableInfo.RecordCount);
        return false;
    }

    tx->Lock(tableName, NYT::LM_SNAPSHOT);
    auto reader = tx->CreateTableReader<NYT::TNode>(tableName);
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        TString host = row[F_YAMR_KEY].AsString();
        if (scheme == E_HOST_SCHEME_ROBOT) {
            if (host.find("https://") == TString::npos && host.find("ftp://") == TString::npos) {
                size_t del = host.find("://");
                if (del != TString::npos) {
                    host = host.substr(del + 3);
                }
            }
        } else if (scheme == E_HOST_SCHEME_NONE) {
            size_t del = host.find("://");
            if (del != TString::npos) {
                host = host.substr(del + 3);
            }
        }

        hosts.insert(host);
    }

    if (hosts.size() < thresholdCount) {
        LOG_ERROR("loaded low record count from webmaster hosts table %s: %lu", tableName.data(), hosts.size());
        return false;
    }

    LOG_INFO("loaded %lu hosts from webmaster hosts table %s", hosts.size(), tableName.data());
    return true;
}

} //namespace NYTUtils
} //namespace NWebmaster
