#pragma once

#include <util/generic/hash_set.h>
#include <util/generic/string.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/url.h>

namespace NWebmaster {
namespace NYTUtils {

enum EHostScheme {
    E_HOST_SCHEME_FULL,
    E_HOST_SCHEME_ROBOT,
    E_HOST_SCHEME_NONE,
};

bool LoadWebmastersHosts(NYT::IClientBasePtr client, const TString &tableName, THashSet<TString> &hosts, size_t thresholdCount = 1, EHostScheme scheme = E_HOST_SCHEME_FULL);

template<class TContainer>
void LoadHosts(NYT::IClientBasePtr client, const TString &sourceTable, const TString &column, TContainer &hosts, bool convertIdn = false, bool toLower = false) {
    auto reader = client->CreateTableReader<NYT::TNode>(sourceTable);
    for (; reader->IsValid(); reader->Next()) {
        const NYT::TNode &row = reader->GetRow();
        TString host = row[column].AsString();
        if (toLower) {
            host.to_lower();
        }
        if (convertIdn) {
            TString asciiHost;
            if (NUtils::IDNHostToAscii(host, asciiHost)) {
                hosts.insert(asciiHost);
            } else {
                LOG_ERROR("unable to parse hostname: %s", host.data());
            }
        } else {
            hosts.insert(host);
        }
    }
}

} //namespace NYTUtils
} //namespace NWebmaster
