#pragma once

#include <mapreduce/yt/interface/client.h>


namespace NWebmaster {
namespace NYTUtils {


class TWriterMockImpl : public NYT::INodeWriterImpl {
public:
    explicit TWriterMockImpl(TVector<TVector<NYT::TNode>> &value)
            : Value(value) {
    }

    virtual void AddRow(const NYT::TNode &row, size_t tableIndex) override {
        Value[tableIndex].push_back(row);
    }

    virtual void AddRow(NYT::TNode &&row, size_t tableIndex) override {
        Value[tableIndex].push_back(std::move(row));
    }

    virtual size_t GetTableCount() const override {
        return Value.size();
    }

    virtual void FinishTable(size_t) override {}

    virtual void Abort() override {
        Value.clear();
    }

    TVector<TVector<NYT::TNode>> &Value;
};

class TReaderMockImpl : public NYT::INodeReaderImpl {
public:
    explicit TReaderMockImpl(TVector<NYT::TNode> value)
            : Value(std::move(value)) {
    }

    virtual const NYT::TNode &GetRow() const override {
        return Value.at(TableIndex);
    }

    virtual bool IsValid() const override {
        return Valid;
    }

    virtual void Next() override {
        TableIndex++;
        Valid = TableIndex < Value.size();
    }

    virtual ui32 GetTableIndex() const override {
        return TableIndex;
    }

    virtual ui32 GetRangeIndex() const override {
        return 0;
    }

    virtual ui64 GetRowIndex() const override {
        ythrow yexception() << "unsupported operation";
    }

    virtual void NextKey() override {
        Next();
    }

    virtual void MoveRow(NYT::TNode *) override {
        ythrow yexception() << "unsupported operation";
    }

private:
    ui32 TableIndex = 0;
    bool Valid = true;
    const TVector<NYT::TNode> Value;
};

} // namespace NYTUils
} // namespace NWebmaster
