#pragma once

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

#include <wmconsole/version3/wmcutil/http_client.h>

namespace NWebmaster {

struct TTransferManager {   //https://wiki.yandex-team.ru/yt/userdoc/transfermanager/
    const static char *BANACH;
    const static char *HAHN;

    struct TTaskInfo {
        enum EState {
            RUNNING,
            COMPLETED,
            FAILED,
        };

        TTaskInfo() = default;
        TTaskInfo(const TString &jsonContent);

        EState NameToState(const TString &name);

    public:
        time_t CreationTime = 0;
        int DurationMinutes = 0;
        //time_t StartTime = 0;
        EState State = FAILED;
    };

public:
    TTransferManager(const TString &token, const TString &api = "http://transfer-manager.yt.yandex.net/api/v1/tasks/", size_t timeout = 30000);

    TString PostTask(const TString &sourceCluster, const TString &sourceTable, const TString &destCluster, const TString &destTable);
    void PostTaskAndWait(const TString &sourceCluster, const TString &sourceTable, const TString &destCluster, const TString &destTable);
    bool GetTaskInfo(const TString &taskId, TTaskInfo &info);
    void WaitForTaskDone(const TString &taskId);

private:
    TString GetCopyJsonParams(const TString &sourceCluster, const TString &sourceTable, const TString &destCluster, const TString &destTable);
    TString HttpGetRequest(const TString &handler);
    TString HttpPostRequest(const TString &handler, const TString &data);

    static void DefaultLogInfo(const TString &msg);

public:
    const TString Api;
    const size_t Timeout;
    const TString Token;

public:
    static void (*LogInfo)(const TString &msg);
};

} //namespace NWebmaster
